@ECHO OFF
REM 
REM Retrospect Email Notifier
REM
REM     A Retrospect external script to email reports for script executions.
REM Recipients and other required information for using this script are set
REM below in the "Email Group Properties". If you are using Retrospect's Backup
REM Server you need to schedule your email reports as detailed in the external
REM scripts read me.
REM(C) 2012 Retrospect, Inc. Portions (C) 1989-2010 EMC Corporation. All rights reserved.Copyright 2004-2006 EMC Corporation
REM


REM -------- Begin Email Group Properties -------------------------------------
REM You need to edit the following email group properties.

REM Put your mail server here
set kMailServer="yourSMTPmailServer.com"

REM Email address of the sender
set kMailSender="sender name<firstName_lastName@companyName.com>"

REM  To send mail to more than one person, enter the addresses separated by
REM  semicolons, for example: 
REM  "name one<name_one@your_company.com>;name two<name_two@your_company.com>"

REM These recipients will get emails for all events
set kMainGroup="name one<name_one@your_company.com>;name two<name_two@your_company.com>"

REM These recipients will get emails only when fatal errors occur
set kFatalErrorGroup=""
	
REM These recipients will get emails when there is no fatal error
set kSuccessGroup=""

REM These recipients will get emails only when Retrospect needs new media
set kMediaRequestGroup=""

REM The following is the time at which the MediaRequest message is sent. 
REM The time unit must be in 5 minute increments and the minimum value is 5 minutes.
set MediaRequestNotificationTime="5"

REM -------- End of Email Group Properites ------------------------------------


REM Set up the temporary file names for each type of report
set stdReport=RetroStdReport.txt
set BUSFileName=RetroBUSfile.txt
set tempFile=RetroTemp.txt
set mailLog=mailerr.txt

set dantzHeader=Report generated by Retrospect.
set lineDelim=------------------------

REM The following code branches to the procedure labels below, it should not be
REM modified.

If NOT {%1}=={} goto :ENDMSG
	Echo     This is a Retrospect external script to email reports for script executions.
	Echo Recipients and other required information for using this script are set
	Echo by editing this file in the "Email Group Properties" section.
	Echo     To use this file, copy it to the Retrospect directory.
	pause
	goto :EXIT
:ENDMSG
If NOT {%kMailServer%}=={"yourSMTPmailServer.com"} goto :ENDWARNING
	Echo     You must first set the name of your mail server and other 
	Echo required information for using this script by editing the 
	Echo "Email Group Properties" section located in this file.
	pause
	goto :EXIT
:ENDWARNING

set _TRIGGERSCRIPT=%0
set _PROC=%1
shift
goto :%_PROC%

REM -- Begin StartApp ---------------------------------------------------------
:StartApp

REM Clear the temporary email files if the power went off
if Exist %stdReport% del %stdReport%
if Exist %BUSFileName% del %BUSFileName%
if Exist %tempFile% del %tempFile%
goto :EXIT
REM -- End StartApp -----------------------------------------------------------


REM -- Begin StartScript ------------------------------------------------------
:StartScript
set scriptName=%1
set startDate=%2

if EXIST %BUSFileName% goto :end_StartScript				REM skip Backup Server scripts
echo %dantzHeader% > %stdReport%
echo %lineDelim% >> %stdReport%
echo Script %scriptName% started on %startDate%. >> %stdReport%
echo %lineDelim% >> %stdReport%
:end_StartScript
goto :EXIT
REM -- End StartScript --------------------------------------------------------


REM -- Begin EndScript --------------------------------------------------------
:EndScript
set scriptName=%1
set numErrors=%2
set fatalErrCode=%3
set fatalErrMsg=%4

REM Successful script execution will dispatch the regular report 
REM to the kMainGroup and kSuccessGroup user groups.
if EXIST %BUSFileName% goto :EXIT
if NOT %fatalErrCode%=="0" goto :error_EndScript
	if %numErrors%=="0" set errMsg=successfully
	if %numErrors%=="1" set errMsg=with 1 error
	if {"%errMsg%"}=={""} set errMsg=with %numErrors% errors

	set mailSubject="Retrospect: Execution completed %errMsg%"
	echo %lineDelim% >> %stdReport%
	echo Script %scriptName% finished %errMsg%. >> %stdReport%
	echo %lineDelim% >> %stdReport%
	mailsndr %kMailServer% %mailSubject% %kMailSender% -t %kMainGroup%;%kSuccessGroup% -e %mailLog% %stdReport%
	goto :end_EndScript
:error_EndScript
	set mailSubject="Retrospect script finished with errors"
	echo Script %scriptName% finished with errors. >> %stdReport%
	echo Error code %fatalErrCode% %fatalErrMsg%. >> %stdReport%
	mailsndr %kMailServer% %mailSubject% %kMailSender% -t %kMainGroup%;%kFatalErrorGroup% -e %mailLog% %stdReport% 
:end_EndScript
del %stdReport%

goto :EXIT
REM -- End EndScript ----------------------------------------------------------


REM -- Begin StartBackupServer ------------------------------------------------
:StartBackupServer
set startDate=%1

echo %dantzHeader% > %BUSFileName%
echo %lineDelim% >> %BUSFileName%
echo Backup Server started on %startDate%. >> %BUSFileName%
echo %lineDelim% >> %BUSFileName%

goto :EXIT
REM -- End StartBackupServer --------------------------------------------------


REM -- Begin StopBackupServer -------------------------------------------------
:StopBackupServer
set endDate=%1

echo %lineDelim% >> %BUSFileName%
echo Backup Server stopped on %endDate%.>> %BUSFileName%
call %_TRIGGERSCRIPT% SendBUSReport
del %BUSFileName%

goto :EXIT
REM -- End StopBackupServer ---------------------------------------------------


REM -- Begin SendBUSReport ----------------------------------------------------
:ATSendBUSReport
REM The PATH variable doesn't contain the path to the mailsndr.exe when run under
REM the AT command so we pass it in and set the current directory to it here.
if NOT {%1}=={} chdir /d %1
REM Drop into normal SendBUSReport

:SendBUSReport
if NOT EXIST %BUSFileName% goto :EXIT
set mailSubject="Retrospect: Backup Server Report"
mailsndr %kMailServer% %mailSubject% %kMailSender% -t %kMainGroup% -e %mailLog% %BUSFileName%

REM Reset the file
echo %dantzHeader% > %BUSFileName%
echo %lineDelim% >> %BUSFileName%
echo Retrospect Backup Report >> %BUSFileName%
echo %lineDelim% >> %BUSFileName%

goto :EXIT
REM -- End SendBUSReport ------------------------------------------------------


REM -- Begin EndSource --------------------------------------------------------
:EndSource
set scriptName=%1
shift
set sourceName=%1
shift
set sourcePath=%1
shift
set clientName=%1
shift
set kbBackedUp=%1
shift
set numFiles=%1
shift
set duration=%1
shift
set sourceStart=%1
shift
set sourceEnd=%1
shift
set scriptStart=%1
shift
set backupSet=%1
shift
set backupAction=%1
shift
set parentVol=%1
shift
set numErrs=%1
shift
set fatalErrCode=%1
shift
set fatalErrMsg=%1

REM Log that we sent a media request in the current report

set logFile=%stdReport%
if EXIST %BUSFileName% set logFile=%BUSFileName%

if NOT %fatalErrCode%=="0" goto :EndSrcElse
	if NOT %numErrs%=="0" set errMsg= with %numErrs% errors
	if %numErrs%=="1" set errMsg= with 1 error

	echo Script %scriptName% finished a %backupAction% backup to %backupSet% on %sourceEnd%>> %logFile%
	echo %numFiles% files (%kbBackedUp% KB) on %sourceName% were backed up in %duration% seconds. >> %logFile%
	echo . >> %logFile%
	goto :EndSrcIf
:EndSrcElse
	echo Script %ScriptName% failed to backup volume %sourceName% >> %logFile%
	echo with error %fatalErrCode% - %fatalErrMsg%. >> %logFile%
:EndSrcIf

goto :EXIT
REM -- End EndSource ----------------------------------------------------------


REM -- begin MediaRequest -----------------------------------------------------
:MediaRequest
set mediaLabel=%1
set mediaName=%2
set mediaIsKnown=%3
set timeWaited=%4

if NOT %timeWaited%==%MediaRequestNotificationTime% goto :end_MediaRequest
		      
REM Log that we sent a media request in the current report
set logFile=%stdReport%
if EXIST %BUSFileName% set logFile=%BUSFileName%

echo %dantzHeader% > %tempFile%
echo %lineDelim% >> %tempFile%
echo Retrospect needs media %mediaName% (%mediaLabel%). >> %tempFile%
if {%mediaIsKnown%}=={"true"} goto :Known_MediaRequest
	echo This is either a new or unknown media. >> %tempFile%
	goto :end_knownMediaRequest
:Known_MediaRequest
	echo Retrospect has backed up to this media before. >> %tempFile%
:end_knownMediaRequest

echo Retrospect has waited %timeWaited% minutes. >> %tempFile%
echo %lineDelim% >> %tempFile%

REM send it to the main and kMediaRequestGroup
mailsndr %kMailServer% "Retrospect: MediaRequest" %kMailSender% -t %kMediaRequestGroup%;%kMainGroup% -e %mailLog% %tempFile%

REM log message
cat %tempFile% >> %logFile%
del %tempFile% 
:end_MediaRequest

goto :EXIT
REM -- End MediaRequest -------------------------------------------------------


REM -- Begin TimedOutMediaRequest ---------------------------------------------
:TimedOutMediaRequest
set mediaLabel=%1
set mediaName=%2
set mediaIsKnown=%3
set waited=%4

REM Log that we sent a media request in the current report
set logFile=%stdReport%
if EXIST %BUSFileName% set logFile=%BUSFileName%

set mailSubject="Retrospect media request timed out"
echo %dantzHeader% > %tempFile%
echo %lineDelim% >> %tempFile%
echo Media request for media %mediaName% (%mediaLabel%) timed out before script could finish. >> %tempFile%
mailsndr %kMailServer% %mailSubject% %kMailSender% -t %kMediaRequestGroup%;%kMainGroup% -e %mailLog% %tempFile%

REM log message
cat %tempFile% >> %logFile%
del %tempFile%

goto :EXIT
REM -- End TimeOutMediaRequest ------------------------------------------------


REM -- Begin FatalBackupError -------------------------------------------------
:FatalBackupError
set scriptName=%1
set failureCause=%2
set errCode=%3
set errMsg=%4
set errZone=%5

REM Log that we sent a media request in the current report
set logFile=%stdReport%
if EXIST %BUSFileName% set logFile=%BUSFileName%

set mailSubject="Retrospect Fatal Backup Error"
echo Script %scriptName% failed with error code %errCode% - %errMsg% in %errZone%. > %tempFile%
mailsndr %kMailServer% %mailSubject% %kMailSender% -t %kMainGroup%;%kFatalErrorGroup% -e %mailLog% %tempFile%

REM log message
cat %tempFile% >> %logFile%
del %tempFile%

goto :EXIT
REM -- End FatalBackupError ---------------------------------------------------

REM unused procedure tags
:EndApp
:StartSource
:ScriptCheckFailed
:NextExec
:StopSched
:PasswordEntry

:EXIT
